def read_text(prompt):
    '''
    Wyświetla monit i czyta ciąg tekstu.
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Zwraca ciąg znaków zawierający tekst wprowadzony przez użytkownika.
    '''
    while True:  # pętla nieskończona
        try:
            result=input(prompt) # czytanie danych wejściowych
            # jeśli dotarliśmy do tego miejsca, to nie zgłoszono wyjątku
            # przerwanie działania pętli
            break
        except KeyboardInterrupt:
            # jeśli dotarliśmy do tego miejsca, to użytkownik nacisnął Ctrl + C
            print('Wprowadź tekst')

    # zwrócenie wyniku
    return result


def read_float(prompt):
    '''
    Wyświetla monit i wczytuje liczbę.
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę zmiennoprzecinkową reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    while True:  # pętla nieskończona
        try:
            number_text=read_text(prompt)
            result=input(prompt) # czytanie danych wejściowych
            # jeśli dotarliśmy do tego miejsca, to nie zgłoszono wyjątku
            # przerwanie działania pętli
            break
        except ValueError:
            # jeśli program dotarł do tego miejsca, to użytkownik wprowadził nieprawidłową liczbę
            print('Podaj liczbę ')

    # zwrócenie wyniku
    return result

def read_int(prompt):
    '''
    Wyświetla monit i wczytuje liczbę.
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę całkowitą reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    while True:  # pętla nieskończona
        try:
            number_text=read_text(prompt)
            result=int(number_text) # czytanie danych wprowadzonych przez użytkownika
            # jeśli dotarliśmy do tego miejsca, to nie zgłoszono wyjątku
            # przerwanie działania pętli
            break
        except ValueError:
            # jeśli program dotarł do tego miejsca, to użytkownik wprowadził nieprawidłową liczbę
            print('Podaj liczbę ')

    # zwrócenie wyniku
    return result

def read_float_ranged(prompt, min_value, max_value):
    '''
    Wyświetla monit i wczytuje liczbę.
    min_value określa minimalną wartość (włącznie); 
    max_value określa wartość maksymalną (włącznie).
    Nie wykrywa, czy max i min są błędne
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę zmiennoprzecinkową reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    if min_value>max_value:
        # Jeśli program dotarł do tego miejsca, to parametry min_value i max_value 
        # są podane odwrotnie 
        raise Exception('Wartość minimalna jest większa od wartości maksymalnej.')
    while True:  # pętla nieskończona
        result=read_float(prompt)
        if result<min_value:
            # Wprowadzona wartość jest za mała
            print('Ta liczba jest za mała.')
            print('Minimalna wartość to:', min_value)
            # Powtarzaj pętlę odczytu liczby
            continue 
        if result>max_value:
            # Wprowadzona wartość jest zbyt duża
            print('Ta liczba jest za duża')
            print('Maksymalna wartość to:', max_value)
            # Powtarzaj pętlę odczytu liczby
            continue
        # Jeśli program doszedł do tego miejsca, to liczba jest prawidłowa
        # przerwanie działania pętli
        break
    # zwrócenie wyniku
    return result


def read_int_ranged(prompt, min_value, max_value):
    '''
    Wyświetla monit i wczytuje liczbę.
    min_value określa minimalną wartość (włącznie); 
    max_value określa wartość maksymalną (włącznie).
    Nie wykrywa, czy max i min są błędne
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę całkowitą reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    if min_value>max_value:
        # Jeśli program dotarł do tego miejsca, to parametry min_value i max_value 
        # są podane odwrotnie 
        raise Exception('Wartość minimalna jest większa od wartości maksymalnej.')
    while True:  # pętla nieskończona
        result=read_int(prompt)
        if result<min_value:
            # Wprowadzona wartość jest za mała
            print('Ta liczba jest za mała.')
            print('Minimalna wartość to:', min_value)
            # Powtarzaj pętlę odczytu liczby
            continue 
        if result>max_value:
            # Wprowadzona wartość jest zbyt duża
            print('Ta liczba jest za duża')
            print('Maksymalna wartość to:', max_value)
            # Powtarzaj pętlę odczytu liczby
            continue
        # Jeśli program doszedł do tego miejsca, to liczba jest prawidłowa
        # przerwanie działania pętli
        break
    # zwrócenie wyniku
    return result

def readme():
    print('''Witaj w module BTCInput wersja 1.0

Możesz użyć funkcji z tego modułu do czytania liczb i ciągów znaków w Twoich programach.
Funkcje są używane w następujący sposób: 
text = read_text(monit)
int_value = read_int(monit)
float_value = read_float(monit)
int_value = read_int_ranged(monit, wartość_max, wartość_min)
float_value = read_float_ranged(monit, wartość_max, wartość_min)

Przyjemnego używania.

Rob Miles''')

if __name__ == '__main__':
    # Przedstawienie się modułu BTCInput
    readme()

